<?php
/**
*
* created 08.08.2007 - 16:57:40
*
* class for html output methods
*
* @filesource
* @package aritso_cms
* @author Andreas Renk <a.renk@aritso.net>
* @copyright aritso - Internet Solutions
* @link http://www.aritso.net
*
*/

/**
 * create html elements
 *
 */
class HTML
{
	/**
	 * generates the html image element <img>
	 *
	 * @param       string   $src			the image source
	 * @param       string   $alt			the alternative text (will also be used for the title attribute)
	 * @param       string   $parameters	further parameters for the html element
	 * @param       string   $width			the image width (will be calculated if empty, the height is proportional)
	 * @param 		string	 $height		the image height (will be calculated if empty, the width is proportional)
	 * @return      string   Returns a HTML formatted string
	 */
	public function image($src, $alt = '', $parameters = '', $width = '', $height = '')
	{
	    $image = '<img src="' . $src . '" alt="' . $alt . '"';

	    // fopen doesn't work with ssl/https
	    // to do this, we must using cURL Library
	    $calc_dimensions = (substr_count($src, 'https:') == 1) ? false : true;

		if (($width == "" || $height == "") && $calc_dimensions == true && (ini_get('allow_url_fopen')=='On'||ini_get('allow_url_fopen')=='1' ))
		{
			$img_file = @fopen($src, "r");
			$prop = ($img_file) ? @getimagesize($src) : '';

			if (is_array($prop)) $image .= ' '.$prop[3];
	    }
		else
		{
		  $image .= ' width="' . $width . '"';
	      $image .= ' height="' . $height . '"';
	    }

	    if (!empty($alt) && substr_count($parameters, 'title="') == 0)
		{
	      $image .= ' title="' . $alt . '"';
	    }

	    if (!empty($parameters))
		{
	      $image .= ' ' . $parameters;
	    }

	    $image .= ' />';

	    return $image;
	}


	/**
	 * generates the html hyperlink element <a>
	 *
	 * @param       string   $page			the url
	 * @param       string   $object		the linktext or linkimage
	 * @param       string   $title			the title attribute
	 * @param       string   $parameters	further parameters for the html element
	 * @return      string   Returns a HTML formatted string
	 */
	public function href_link($page, $object = "", $title = "", $parameters = "", $sef = 'false')
	{
		global $main;

		if($sef == 'true')
		{
			$page = $this->sef_url($page);
		}

		$page = htmlentities($page);

		if(empty($object)) $object = $page;

		$link = '<a href="'.$page.'"';

		if(false === $title)
		{

		}
		elseif(!empty($title))
		{
			$link .= ' title="' . $main->remove_line_break($title, '&nbsp;-&nbsp;') . '"';
		}
		else
		{
			$link .= ' title="' . trim(strip_tags($object)) . '"';
		}

		if($parameters != "")
		{
			$link .= ' '.$parameters;
		}

		$link .= '>'.$object.'</a>';

		return $link;
	}

	/**
	 * generates a search engine friendly url if the url is listed in th db table or if the url contains a registered addon
	 *
	 * @param       string   $url			the url
	 * @return      string   Returns a URL string
	 */
	private function sef_url($url)
	{
		global $main, $db;

		// parse url
		$arr_url = parse_url($url);
		if(isset($arr_url['query'])) parse_str($arr_url['query'], $arr_request);

		// make the system url substring
		$substr_system_url = str_replace(DIR_WS_ROOT_PATH, '', $url);

		// at first, we check if there is a sef url in the db table
		$sef_url_query = $db->query("SELECT substr_sef_url FROM sef_url WHERE substr_system_url LIKE '" . $db->db_input($substr_system_url) . "' LIMIT 1");

		// and we check the url for the second way: if the url is not listed in db table
		if(isset($arr_url['query']))
		{
			// we check, if the url contains a registered addon
			$addon_query = $db->query("SELECT id FROM addons WHERE dirname LIKE '" . $arr_request['addon'] . "' LIMIT 1");
		}


		// if sef_url exist: set $url to the sef_url
		if($db->num_rows($sef_url_query) == 1)
		{
			$url = $db->row($sef_url_query);
			$sef_url = DIR_WS_ROOT_PATH . $url->substr_sef_url;
		}
		elseif(isset($addon_query) && $db->num_rows($addon_query) == 1)	// if sef_url not exist and the url contains an addon
		{
			// built the new url
			$sef_url = DIR_WS_ROOT_PATH;

			if(isset($arr_request['addon'])) $sef_url .= $arr_request['addon'] . DIRECTORY_SEPARATOR;
			if(isset($arr_request['action'])) $sef_url .= $arr_request['action'] . DIRECTORY_SEPARATOR;
			if(isset($arr_request['task'])) $sef_url .= $arr_request['task'] . DIRECTORY_SEPARATOR;

			unset($arr_request['addon'], $arr_request['action'], $arr_request['task']);

			foreach($arr_request as $key => $value)
			{
				$sef_url .= '' . $key . '-' . $value . DIRECTORY_SEPARATOR;
			}
		}
		else
		{
			$sef_url = $url;
		}

		return $sef_url;
	}

	/**
	 * generates the html form element <form>
	 *
	 * @param       string   $name			the form name
	 * @param       string   $action		the form action attribute (PHP_SELF if empty)
	 * @param       string   $method		the sen method (default: post)
	 * @param       string   $parameters	further parameters for the html element
	 * @return      string   Returns a HTML formatted string
	 */
	public function form($name, $action = '', $method = 'post', $parameters = '')
	{
	  if(empty($action)) $action = $_SERVER['PHP_SELF'];

	  $form = '<form name="' . $name . '" action="' . $action . '" method="' . $method . '"';

	  if (!empty($parameters)) $form .= ' ' . $parameters;

	  $form .= '>';

	  return $form;
	}


	/**
	 * generates the html input element <input> with the attribute type="image"
	 *
	 * @param       string   $image			the image source
	 * @param       string   $alt			the alt text
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function image_submit($image, $alt = '', $parameters = '', $close_form = false)
	{
	  $image_submit = '<input type="image" src="' . $image . '" alt="' . $alt . '"';

	  if (!empty($alt)) $image_submit .= ' title=" ' . $alt . ' "';

	  if(empty($parameters))
	  {
	      $parameters = ' style="border:0px; background-color:transparent;"';
	  }


	  $image_submit .= ' ' . $parameters;

	  $image_submit .= ' />';

	  if ($close_form == true) $image_submit .= "\n" . '</form>';

	  return $image_submit;
	}


	/**
	 * generates the html input element <input> with the attribute type="submit"
	 *
	 * @param       string   $value			the button value
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function form_submit($value, $parameters = '', $close_form = false)
	{

	  $form_submit = '<input type="submit" value="' . $value . '"';

	  if(substr_count($parameters, 'class') == 0) $parameters .= ' class="button"';

	  if (!empty($parameters)) $form_submit .= ' ' . $parameters;

	  $form_submit .= ' />';

	  if ($close_form == true) $form_submit .= "\n" . '</form>';

	  return $form_submit;
	}


	/**
	 * generates the html input element <input>
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		string	 $type			the type of the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function input_field($name, $value = '', $parameters = '', $type = 'text', $close_form = false)
	{
	  $field = '<input type="' . $type . '" name="' . $name . '"';

	  $field .= ' value="' . $value . '"';

	  if(substr_count($parameters, 'id="') == 0) $field .= ' id="' . $name . '"';

	  if($parameters != "") $field .= ' ' . $parameters;

	  $field .= ' />';

	  if ($close_form == true) $field .= "\n" . '</form>';

	  return $field;
	}


	/**
	 * generates the html input element <input> with the attribute type="password"
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function password_field($name, $value = '', $parameters = '', $close_form = false)
	{
	  return $this->input_field($name, $value, $parameters, 'password', $close_form);
	}

	/**
	 * generates a html selection element <input>
	 * alias function for checkbox_field() and radio_field()
	 *
	 * @param       string   $name			the name of the form element
	 * @param 		string	 $type			the type of the html element
	 * @param       string   $value			the value of the form element
	 * @param       bool	 $checked		true checked, false unchecked
	 * @param       string   $label			the label tag
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	private function selection_field($name, $type, $value = '', $checked = false, $label = '', $parameters = '', $close_form = false)
	{
	  $selection = '<input type="' . $type . '" name="' . $name . '"';

	  if ($value != "") $selection .= ' value="' . $value . '"';

	  if (!empty($label))
	  {
	  	if(substr_count($parameters, 'id="') == 0)
	  	{
	  		$id = str_replace(' ', '_', 'id_' . microtime());
	  		$selection .= ' id="' . $id . '"';
	  	}
	  	else
	  	{
	        preg_match('/(id=")([a-zA-Z0-9_]*)(")/', $parameters, $res);
	        $id = (isset($res[2])) ? $res[2] : "";
	  	}
	  }

	  if($checked == true)
	  {
	    $selection .= ' CHECKED';
	  }

	  $selection .= ' ' . $parameters;

	  $selection .= ' />';

	  if (!empty($label))
	  {
	  	$selection .= '&nbsp;<label for="' . $id . '">' . $label . '</label>';
	  }

	  if ($close_form == true) $selection .= "\n" . '</form>';

	  return $selection;
	}

	/**
	 * generates the html input element <input> with the attribute type="checkbox"
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param       bool	 $checked		true checked, false unchecked
	 * @param       string   $label			the label tag
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function checkbox_field($name, $value = '', $checked = false, $label = '', $parameters = '', $close_form = false)
	{
	  $parameters .= ' class="checkbox_field"';

	  return $this->selection_field($name, 'checkbox', $value, $checked, $label, $parameters, $close_form);
	}


	/**
	 * generates the html input element <input> with the attribute type="radio"
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param       bool	 $checked		true checked, false unchecked
	 * @param       string   $label			the label tag
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function radio_field($name, $value = '', $checked = false, $label = '', $parameters = '', $close_form = false)
	{
	  $parameters .= ' class="radio_field"';

	  return $this->selection_field($name, 'radio', $value, $checked, $label, $parameters, $close_form);
	}


	/**
	 * generates the html textarea element <textarea>
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $text			the value of the form element
	 * @param       bool	 $width			default width=10, usually it will be set in css file
	 * @param       string   $height		default height=20, usually it will be set in css file
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function textarea_field($name, $text = '', $width = '', $height = '', $parameters = '', $close_form = false)
	{
		if(empty($width)) $width = 10;
		if(empty($height)) $height = 20;

		$field = '<textarea name="' . $name . '" cols="' . $width . '" rows="' . $height . '"';

		if($parameters) $field .= ' ' . $parameters;

		$field .= '>';

		if ($text)
		{
		  $field .= $text;
		}

		$field .= '</textarea>';

		if ($close_form == true) $field .= "\n" . '</form>';

		return $field;
	}


	/**
	 * generates the html input element <input> with the attribute type="hidden"
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param       string   $parameters	further parameters for the html element
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function hidden_field($name, $value = '', $parameters = '', $close_form = false)
	{
	  $field = '<input type="hidden" name="' . $name . '"';

	  if (!empty($value))
	  {
	    $field .= ' value="' . $value . '"';
	  }

	  if(substr_count($parameters, 'id="') == 0) $field .= ' id="' . $name . '"';

	  if (!empty($parameters)) $field .= ' ' . $parameters;

	  $field .= ' />';

	  if ($close_form == true) $field .= "\n" . '</form>';

	  return $field;
	}


	/**
	 * generates the html select element <select>
	 *
	 * @param       string   $name			the name of the form element
	 * @param       string   $value			the value of the form element
	 * @param		string	 $default		the default value
	 * @param       string   $parameters	further parameters for the html element
	 * @param		string	 $first_option	the first <option>-attribute
	 * @param 		bool	 $close_form	makes the closing form tag </form> if true
	 * @return      string   Returns a HTML formatted string
	 */
	public function pull_down_menu($name, $values, $default = '', $parameters = '', $first_option = '', $close_form = false)
	{
	  $field = '<select name="' . $name . '"';

	  if (!empty($parameters)) $field .= ' ' . $parameters;

	  $field .= '>';

	  if($first_option != '') $field .= '<option value="">' . $first_option . '</option>';

	  for ($i=0, $n=sizeof($values); $i<$n; $i++) {
	    $field .= '<option value="' . $values[$i]['value'] . '"';

		if(is_array($default)) {
			foreach($default as $default_value){
				if ($default_value == $values[$i]['id']) {
				  $field .= ' SELECTED';
				}
			}
		} else {
			if ($default == $values[$i]['id']) {
			  $field .= ' SELECTED';
			}
		}

	    $field .= '>'. $values[$i]['text'] .'</option>';
	  }
	  $field .= '</select>';

	  if ($close_form == true) $field .= "\n" . '</form>';

	  return $field;
	}


	/**
	 * generates a social bookmark icon bar
	 */
	public function social_bookmark_bar()
	{
		global $ws_dynamic_root_path;

		$social_bookmark_bar = BOOKMARKS_BAR_TITLE . ': ';

		$social_bookmark_bar .= $this->href_link('http://www.google.com', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/googlecombookmarks.gif', BOOKMARKS_GOOGLE_TITLE, 'style="margin:1px;"'), BOOKMARKS_GOOGLE_TITLE, 'onclick="window.open(\'http://www.google.com/bookmarks/mark?op=add&amp;hl=de&amp;bkmk=\'+encodeURIComponent(location.href)+\'&amp;annotation=&amp;labels=&amp;title=\'+encodeURIComponent(document.title));return false;" target="_top" rel="nofollow"');
        $social_bookmark_bar .= $this->href_link('http://www.yahoo.com', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/yahoo_myweb.gif', BOOKMARKS_YAHOO_TITLE, 'style="margin:1px;"'), BOOKMARKS_YAHOO_TITLE, 'onclick="window.open(\'http://myweb2.search.yahoo.com/myresults/bookmarklet?t=\'+encodeURIComponent(document.title)+\'&amp;d=&amp;tag=&amp;u=\'+encodeURIComponent(location.href));return false;" target="_top" rel="nofollow"');
        $social_bookmark_bar .= $this->href_link('https://favorites.live.com', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/windows_live.gif', BOOKMARKS_LIVE_TITLE, 'style="margin:1px;"'), BOOKMARKS_LIVE_TITLE, 'onclick="window.open(\'https://favorites.live.com/quickadd.aspx?marklet=1&amp;mkt=en-us&amp;url=\'+encodeURIComponent(location.href)+\'&amp;top=1&amp;title=\'+encodeURIComponent(document.title));return false;" target="_top" rel="nofollow"');
        $social_bookmark_bar .= $this->href_link('http://www.mister-wong.de/add_url', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/misterwong.gif', BOOKMARKS_MRWONG_TITLE, 'style="margin:1px;"'), BOOKMARKS_MRWONG_TITLE, 'onClick="location.href=&quot;http://www.mister-wong.de/index.php?action=addurl&amp;bm_url=&quot;+encodeURIComponent(location.href)+&quot;&amp;bm_description=&quot;+encodeURIComponent(document.title);return false;" target="_top" rel="nofollow"');
        $social_bookmark_bar .= $this->href_link('http://del.icio.us', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/delicious.gif', BOOKMARKS_DELICIOUS_TITLE, 'style="margin:1px;"'), BOOKMARKS_DELICIOUS_TITLE, 'onclick="window.open(\'http://del.icio.us/post?v=2&amp;url=\'+encodeURIComponent(location.href)+\'&amp;title=\'+encodeURIComponent(document.title));return false;" target="_top" rel="nofollow"');
        $social_bookmark_bar .= $this->href_link('http://linkarena.com', $this->image($ws_dynamic_root_path . 'images/social_bookmarks/linkarena.gif', BOOKMARKS_LINKARENA_TITLE, 'style="margin:1px;"'), BOOKMARKS_LINKARENA_TITLE, 'onclick="window.open(\'http://linkarena.com/bookmarks/addlink/?url=\'+encodeURIComponent(location.href)+\'&amp;title=\'+encodeURIComponent(document.title));return false;" target="_top" rel="nofollow"');


		return $social_bookmark_bar;
	}


   public function drawBaseTag($tagName,$parameters="",$innerHTML="",$id=""){
        $content="<".$tagName." ";
        if(empty($parameters)&&empty($id)){
            $content=str_replace(" ","",$content);
        }

        if(!empty($id)){
            $content.="id='" . $id . "' ";
        }

        if(!empty($parameters)){
            if(is_array($parameters)){
                $interim=array();
                foreach($parameters as $attribute=>$value){
                    array_push($interim,$attribute."='" . $value . "'");
                }
                $parameters=implode(' ',$interim);
            }
            $content.=" ".$parameters;
        }
        while(strpos($content, '  ')){
            $content=str_replace('  ',' ',$content);
        }
        if(!empty($innerHTML)){
            $content.=">";
            $content.=$innerHTML;
            $content.="</".$tagName.">";
        }else{
            $content.='/>';
        }

        return $content;
    }

    public function drawNonEnclosingTag($tagName,$parameters='',$id=''){
        return $this->drawBaseTag($tagName,$parameters,'',$id);
    }

    public function drawEnclosingTag($tagName,$innerHTML,$parameters='',$id=''){
        return $this->drawBaseTag($tagName,$parameters,$innerHTML,$id);
    }

    public function drawTagP($innerHTML,$parameters='',$id=''){
        return $this->drawEnclosingTag('div',$innerHTML,$parameters,$id);
    }

    public function shadowBoxLink($imagePath,$inner,$pTitle=""){
        if(!empty($title)){
            $pTitle='title="' . $title . '"';
        }
        $content="
        <a href='" . $imagePath . "' rel='shadowbox' " . $pTitle . ">" . $inner . "</a>
        ";
        return $content;
    }

    public function div($innerHTML,$parameters='',$id=''){
        return $this->drawEnclosingTag('div', $innerHTML,$parameters,$id);
    }
}
?>