<?php

//
// text
define('MD5_HASH_DESCRIPTION', '<p>MD5 steht für Message Digest Algorithm 5. Mit dieser Funktion lassen sich 128-Bit Hashwerte für Zeichenketten oder Dateien erzeugen.
Der Hashwert ist dabei so etwas wie ein Fingerabdruck mit dem man eine Zeichenkette eindeutig identifizieren kann. Das bedeutet, dass nur gleiche 
Zeichenketten den gleichen Hashwert erzeugen. Jede Veränderung an der Zeichenkette erzeugt einen anderen Hashwert.<br />
Seit einiger Zeit ist allerdings bekannt, dass der MD5-Algorithmus zu <a href="http://de.wikipedia.org/wiki/Hashtabelle#Kollisionen" target="_blank" rel="nofollow">Kollissionen</a>
führen kann. Aus heutiger Sicht ist es ratsam auf sicherere Algorithmen wie SHA-256 oder RIPEMD-160 umzusteigen.</p>
<p>Mit unserem Tool können Sie eine beliebige Zeichenkette mit den verschiedensten Hashing-Algorithmen verschlüsseln lassen. Neben md5 stehen %s weitere Hashing-Algorithmen zur Verfügung.</p>');
define('MD5_FORM_TEXT', 'Zeichenkette hier eingeben:');
define('MD5_RESULT_TEXT', '<p>Die Zeichenkette <em>"%s"</em> ergibt folgende Hashwerte:</p><table width="420" border="1" style="border-collapse:collapse;">%s</table>');
define('MD5_SEND_BUTTON_TEXT', 'verschlüsseln');
define('MD5_EXAMPLE_TEXT', '123456');


//
// classes
require_once '../_classes_/check.class.php';
require_once '../_classes_/prepare.class.php';
require_once '../_classes_/html.class.php';

// initialize check
$check = new Check;

// initialize prepare
$prepare = new Prepare;

// initialize html
$html = new HTML;


//
// prepare Get & Post values
if(isset($_REQUEST)) $arr_request = $_REQUEST;


//
// make form
$form_md5_hash = $html->form('md5', 'https://tools.confirado.de/md5hash/index.php') .
                 '<label for="input_string">' . MD5_FORM_TEXT . '</label><br />' .
                 $html->textarea_field('string', $arr_request['string'], 10, 10, 'id="input_string"') . '<br />' .
	             $html->hidden_field('addon', 'aritso-tools') .
	             $html->hidden_field('action', 'md5hash') .
                 $html->form_submit(MD5_SEND_BUTTON_TEXT, '', true);

				 
//
// get hash algos
$hash_algos = hash_algos();

		
//
// number hashes
$numberAddHashAlgos = count($hash_algos);

				 
//
// get hash
if(!isset($arr_request['string']))
{
	$arr_request['string'] = MD5_EXAMPLE_TEXT;
}


$hash_list = '<tr><th style="padding:5px; vertical-align:middle;">Algorithmus [' . $numberAddHashAlgos . ']</th><th style="padding:5px; vertical-align:middle;">Hashwert</th></tr>';

foreach($hash_algos as $algo)
{
    $hash = hash($algo, $arr_request['string']);
    $hash_list .= '<tr><td style="padding:5px; vertical-align:middle;">' . $algo . ':</td><td style="padding:5px;"> ' . $html->input_field($algo, $hash, 'style="width:250px; height:18px; padding:2px;"') . '</td></tr>';
}

$hashes = sprintf(MD5_RESULT_TEXT, nl2br($arr_request['string']), $hash_list);
?>

<!doctype html>
<html lang="de">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="robots" content="noindex,nofollow">

	<link rel="stylesheet" href="../_css_/screen_layout.css">
	
    <title>Zeichenkette verschlüsseln</title>
  </head>
  <body>
  
	<div id="md5_hash_form">
		<?php echo $form_md5_hash; ?>
		<hr style="width:300px; margin-top:25px; margin-bottom:25px;" />
		<p><b>MD5 Wert:<br /><?php echo hash('MD5', $arr_request['string']); ?></b></p>
	</div>

	<div id="md5_hash"><?php echo $hashes; ?></div>
  
  </body>
</html>