<?php
/**
*
* created 08.08.2007 - 16:57:40
*
* class for checking methods
*
* @filesource
* @package aritso_cms
* @author Andreas Renk <a.renk@aritso.net>
* @copyright aritso - Internet Solutions
* @link http://www.aritso.net
*
*/

/**
 * methods to check input values
 *
 */
class Check
{
	/**
	 * checks the syntax of an e-mail-address
	 *
	 * @param       string   $email	the e-mail-address
	 * @return      bool   true for the correct syntax and false for incorrect syntax
	 */
	private function email($email)
	{
	  // First, we check that there's one @ symbol, and that the lengths are right
	  if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
	    // Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
	    return false;
	  }
	  // Split it into sections to make life easier
	  $email_array = explode("@", $email);
	  $local_array = explode(".", $email_array[0]);
	  for ($i = 0; $i < sizeof($local_array); $i++) {
	     if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
	      return false;
	    }
	  }
	  if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
	    $domain_array = explode(".", $email_array[1]);
	    if (sizeof($domain_array) < 2) {
	        return false; // Not enough parts to domain
	    }
	    for ($i = 0; $i < sizeof($domain_array); $i++) {
	      if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9|||]+))$", $domain_array[$i])) {
	        return false;
	      }
	    }
	  }
	  return true;
	}

	/**
	 * checks if the date is correct
	 *
	 * @param       string   $date	the date must be submitted in the format dd.mm.yyyy
	 * @return      bool	Returns true if the date is correct and false for an incorrect date
	 */
	private function date($date)
	{
		$dots = substr_count($date, ".");
		$length = strlen($date);

		if($dots == 2 && $length == 10)
		{

		  $arr_date = explode(".", $date);
		  $check = checkdate($arr_date[1], $arr_date[0], $arr_date[2]);

		}
		else
		{

		  $check = false;

		}

		return $check;
	}

	/**
	 * checks if the time is correct
	 *
	 * @param       string   $time	the time must be submitted in the format hh:mm
	 * @return      bool	Returns true if the date is correct and false for an incorrect date
	 */
	private function time($time)
	{

		$check = false;

		$doubledots = substr_count($time, ":");

		if($doubledots == 1)
		{
		  $arr_time = explode(":", $time);

		  if(!empty($arr_time[0]) && $arr_time[0] >= 0 && $arr_time[0] <=23)
		  {
		  	$check = true;
		  }
		  else
		  {
		  	$check = false;
		  }
		  if(!empty($arr_time[1]) && $arr_time[1] >= 0 && $arr_time[1] <=59)
		  {
		  	$check = true;
		  }
		  else
		  {
		  	$check = false;
		  }

		}

		return $check;
	}

	/**
	 * checks a variable depending of the method
	 *
	 * @param       mixed    $subject	the variable to check
	 * @param       string   $method	the checking method (numeric, time, date, email, url)
	 * @return      bool   Returns true if the variable is ok and false if not
	 */
	public function input($subject, $method)
	{
		switch($method)
		{
		case "numeric":
            (bool)$result = preg_match('#^[0-9]+\.*[0-9]*$#', $subject);
		break;

		case "time":
		    (bool)$result = $this->time($subject);
		break;

		case "date":
		    (bool)$result = $this->date($subject);
		break;

		case "email":
		    (bool)$result = $this->email($subject);
		break;

		case "url":
		    //(bool)$result = preg_match("#^(http|https)+(://www.)+([a-z0-9-_.]{2,}\.[a-z]{2,4})$#i", $subject);
		    (bool)$result = preg_match('#^(http|https)\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $subject);
		break;

		case "string":
		    (bool)$result = (empty($subject)) ? false : true;
		break;

		default:
			(bool)$result = false;
		break;
		}

		return $result;
	}

	/**
	 * checks if an value in the database already exist
	 *
	 * @param       string  $new_entry	the value of the new db entry
	 * @param       string  $table_col	the db-column
	 * @param 		string	$db_table	the db-table to use
	 * @param 		string	$parameters	additional sql parameters
	 * @return      mixed   Returns the id's of the existing entries or false if no entry exist
	 */
	public function is_multiple_db_entry($new_entry, $table_col, $db_table, $parameters = '')
	{
		global $db;

		$db->query("SELECT id FROM " . $db_table . " WHERE " . $table_col . " LIKE '" . $new_entry . "' " . $parameters);
		$is_multiple = $db->num_rows();
		if($is_multiple == 0)
		{
			return false;
		}
		else
		{
			return $is_multiple;
		}
	}

	/**
	 * gets the status of the user id from database table user_account_users
	 *
	 * @param       integer  $user_id the user id
	 * @return      array	 associative array with the status value array-key = status
	 */
	public function user_status($user_id)
	{
		$status_query = wat_db_query("SELECT status FROM user_account_users WHERE id=" . $user_id);
		$arr_status = wat_db_fetch_array($status_query);

		return $arr_status['status'];
	}

	/**
	 *
	 */
	public function check_menu_tree_4_id($menu_id, $curr_menu_id)
	{
		global $db;

		$return = false;

		$menu_query = $db->query("SELECT `id` FROM menu_items WHERE `parent_id` = " . $menu_id);

        if($db->num_rows($menu_query) > 0)
        {
        	while($menu = $db->row($menu_query))
        	{
        	   if($menu->id == $curr_menu_id)
        	   {
        	       $return = true;
        	   }
        	   elseif($return == false)
        	   {
        	       $return = $this->check_menu_tree_4_id($menu->id, $curr_menu_id);
        	   }
            }
	   }

	   return $return;
	}
	
	public function checkIsRootElementInMenu($idMenu)
	{
	    global $db;
	    $res = $db->query("SELECT parent_id from menu_items where id=".$idMenu);
	    $rows=$db->fetchArrayFromRes($res);
	    if(empty($rows) || $rows[0]['parent_id']==0) return true;
	    return false;
	}
}
?>