<?php
/**
 *
 * created 08.08.2007 - 16:57:40
 *
 * class for preparing methods
 *
 * @filesource
 * @package aritso_cms
 * @author Andreas Renk <a.renk@aritso.net>
 * @copyright aritso - Internet Solutions
 * @link http://www.aritso.net
 *
 */

/**
 * methods to prepare input values
 *
 */
class Prepare
{

    private $main = null;

    public function __construct()
    {
        
    }

    public static function getInstance()
    {
        return new self;
    }

    private function removeLineBreak($value)
	{
        $str = trim($str);
        /*$str = str_replace(chr(13), $replace, $str);*/
        $str = str_replace("<br>", $replace, $str);
        $str = str_replace("<br />", $replace, $str);
        $str = str_replace("\r\n", $replace, $str);
        $str = str_replace("\n", $replace, $str);
        $str = str_replace("\r", $replace, $str);

        return($str);
    }

    /**
     * to convert the superglobals
     * removes all unallowed characters from the value
     *
     * @param       array   $array
     * @return      array   Returns a HTML formatted array
     */
    public function superglobals($array, $process=array())
    {
        $arr_ret = array();
        $mapper=array(
        		'htmlentities'=>'htmlentities',
                'strip_tags'=>'strip_tags',
                'remove_line_break'=>'$this->removeLineBreak',
                'strip_slashes'=>'stripslashes',
                'removeSmartyTags'=>'$this->removeSmartyTags'
                );
                if(!empty($process))
                {
                    foreach($process as $fnc=>$p)
                    {
                        if($p==false)
                        {
                            if(isset($mapper[$fnc]))
                            {
                                unset($mapper[$fnc]);
                            }
                        }
                    }

                }

                foreach($array as $key => $value)
                {
                    if(is_array($value))
                    {
                        $arr_ret[$key] = $this->superglobals($value,$process);
                    }
                    else
                    {
                        $q=$value;
                        foreach($mapper as $mKey=>$fnc)
                        {

                            if(substr_count($fnc, '$this->'))
                            {
                                $fnc=str_replace('$this->', '', $fnc);
                                $q=html_entity_decode(call_user_func(array($this,$fnc),$q));

                            }else{
                                $q=html_entity_decode(call_user_func($fnc,$q));
                            }
                        }

                        $arr_ret[$key] = stripslashes($q);
                    }
                }
                return $arr_ret;
    }


    /**
     * to convert the superglobals
     * removes all unallowed characters from the value
     * but this function allows html-tags
     *
     * @param       array   $array
     * @return      array   Returns a HTML formatted array
     */
    public function superglobals_lite($array,$process=array())
    {
        $process['removeSmartyTags'] = false;
        $process['strip_tags'] = false;
        $process['remove_line_break'] = false;
        return $this->superglobals($array,$process);
    }


    /**
     * to convert a url sting
     * replace unallowed characters in a string to use it in an url
     *
     * @param       string   $url	the url string
     * @return      string   Returns the prepared url
     */
    public function url($url)
    {
        // set the string to lower case
        $url = strtolower($url);

        // search array
        $arr_search = array('', '', '', '', '', '', '');

        /*
         // set to iso
         foreach($arr_search as $key => $value)
         {
         $arr_search_decode[$key] = utf8_decode($value);
         }
         */

        // replace array
        $arr_replace = array('ae', 'ue', 'oe', 'ss', 'ae', 'ue', 'oe');

        $url = str_replace($arr_search, $arr_replace, $url);


        // some other replacements
        $url = ereg_replace('([ |+|#|!|"|\'|§|$|%|&|/|(|)|=|?|`|´|<|>|,|;|:|_])', '-', $url);
        $url = preg_replace("/(-){2,}/","-", $url); # aufeinanderfolgende "-" werden auf genau ein "-" reduziert
        $url = preg_replace("/-$/","", $url); // kill the "-" at the end of the string


        return $url;
    }

    public function sef_url($url)
    {

        $db = new Database();


        // parse url
        $arr_url = parse_url($url);
        if(isset($arr_url['query'])) parse_str($arr_url['query'], $arr_request);

        // make the system url substring
        $substr_system_url = str_replace(DIR_WS_ROOT_PATH, '', $url);

        // at first, we check if there is a sef url in the db table
        $sef_url_query = $db->query("SELECT substr_sef_url FROM sef_url WHERE substr_system_url LIKE '" . $db->db_input($substr_system_url) . "' LIMIT 1");

        // and we check the url for the second way: if the url is not listed in db table
        if(isset($arr_url['query']))
        {
            // we check, if the url contains a registered addon
            $addon_query = $db->query("SELECT id FROM addons WHERE dirname LIKE '" . $arr_request['addon'] . "' LIMIT 1");
        }


        // if sef_url exist: set $url to the sef_url
        if($db->num_rows($sef_url_query) == 1)
        {
            $url = $db->row($sef_url_query);
            $sef_url = DIR_WS_ROOT_PATH . $url->substr_sef_url;
        }
        elseif(isset($addon_query) && $db->num_rows($addon_query) == 1)	// if sef_url not exist and the url contains an addon
        {
            // built the new url
            $sef_url = DIR_WS_ROOT_PATH;

            if(isset($arr_request['addon'])) $sef_url .= $arr_request['addon'] . DIRECTORY_SEPARATOR;
            if(isset($arr_request['action'])) $sef_url .= $arr_request['action'] . DIRECTORY_SEPARATOR;
            if(isset($arr_request['task'])) $sef_url .= $arr_request['task'] . DIRECTORY_SEPARATOR;

            unset($arr_request['addon'], $arr_request['action'], $arr_request['task']);

            foreach($arr_request as $key => $value)
            {
                $sef_url .= '&' . $key . '=' . $value;
            }
        }
        else
        {
            $sef_url = $url;
        }

        return $sef_url;
    }


    public function removeSmartyTags($string)
    {
        $string = preg_replace("/([\{]{1})(.*)([\}])(.*)([\{]{1})([\/]{1})(.*)([\}])/", '', $string); // e.g. {php} echo 1; {/php}
        $string = preg_replace("/([\{]{1})(.*)([\$]{1})(.*)([\}]{1})/", '', $string); // e.g. {$smarty.now}
        $string = preg_replace("/([\{{1}])(.*)(include)(.*)([\}{1}])/", '', $string); // e.g. {include file=test.tpl}
        return $string;
    }


    /**
     * to convert a string with url into string with html link Tags
     * replace url with link tag
     * should not be used with string that already include html tags with link properties
     *
     * @todo add handling for html tags with link properties
     * @param       string   $string    string with url inside
     * @return      string   $string    string with link tag
     */
    public function setLinkInString($string)
    {
        $matches = Array();
        $htmlLink = '<a href="%s">%s</a>';
        $regExp = '/(((f|ht){1}(tp|tps):\/\/)[\w\d\S]+)/i';

        preg_match_all($regExp, $string, $matches, PREG_PATTERN_ORDER);

        foreach ($matches[0] as $value)
        {
            $replace = sprintf($htmlLink, $value, $value);
            $string = str_replace($value, $replace, $string);
        }

        return $string;
    }
}
?>