<?php

//
// text
define('FORM_TIMESTAMP_TEXT', 'Timestamp');
define('FORM_UTC_TEXT', 'Zeitzone');
define('TS2T_SEND_BUTTON_TEXT', 'in Format tt.mm.jjjj umrechnen');
define('FORM_DATE_TEXT', 'Datum (tt.mm.jjjj)');
define('FORM_TIME_TEXT', 'Zeit (hh:mm:ss)');
define('T2TS_SEND_BUTTON_TEXT', 'Datum in Timestamp umrechnen');
define('TS2T_NOTICE', 'Der Timestamp <strong>%s</strong> entspricht dem <strong>%s.%s.%s</strong> um <strong>%s:%s:%s</strong> Uhr.<br />(gilt für UTC%s)');
define('T2TS_NOTICE', 'Der <strong>%s.%s.%s</strong> um <strong>%s:%s:%s</strong> Uhr entspricht dem Timestamp <strong>%s</strong>.<br />(gilt für UTC%s)');


//
// classes
require_once '../_classes_/check.class.php';
require_once '../_classes_/prepare.class.php';
require_once '../_classes_/html.class.php';

// initialize check
$check = new Check;

// initialize prepare
$prepare = new Prepare;

// initialize html
$html = new HTML;


//
// prepare Get & Post values
if(isset($_REQUEST)) $arr_request = $_REQUEST;


//
// set the server timezone
date_default_timezone_set('Europe/Berlin');


//
// declare variables
$arr_timezones = array("UTC-12"     => -12,
                       "UTC-11"     => -11,
                       "UTC-10"     => -10,
                       "UTC-9:30"   => -9.5,
                       "UTC-9"      => -9,
                       "UTC-8"      => -8,
                       "UTC-7"      => -7,
                       "UTC-6"      => -6,
                       "UTC-5"      => -5,
                       "UTC-4"      => -4,
                       "UTC-3:30"   => -3.5,
                       "UTC-3"      => -3,
                       "UTC-2"      => -2,
                       "UTC-1"      => -1,
                       "UTC 0"      => 0,
                       "UTC+1"      => 1,
                       "UTC+2"      => 2,
                       "UTC+3"      => 3,
                       "UTC+3:30"   => 3.5,
                       "UTC+4"      => 4,
                       "UTC+4:30"   => 4.5,
                       "UTC+5"      => 5,
                       "UTC+5:30"   => 5.5,
                       "UTC+5:45"   => 5.75,
                       "UTC+6"      => 6,
                       "UTC+6:30"   => 6.5,
                       "UTC+7"      => 7,
                       "UTC+8"      => 8,
                       "UTC+8:45"   => 8.75,
                       "UTC+9"      => 9,
                       "UTC+9:30"   => 9.5,
                       "UTC+10"     => 10,
                       "UTC+10:30"  => 10.5,
                       "UTC+11"     => 11,
                       "UTC+11:30"  => 11.5,
                       "UTC+12"     => 12,
                       "UTC+12:45"  => 12.75,
                       "UTC+13:00"  => 13,
                       "UTC+14:00"  => 14);


$boolDST = date('I'); //this will be 1 in DST or else 0

if(!isset($arr_request['utc']))
{
	if($boolDST == 1)
	{
		$arr_request['utc'] = 2;
	}
	else
	{
		$arr_request['utc'] = 1;
	}
}

//
// format for cur_timezone
if($arr_request['utc'] > 0)
{
    $cur_timezone_formated = '+' . $arr_request['utc'];
}
elseif($arr_request['utc'] == 0)
{
    $cur_timezone_formated = '&nbsp;' . $arr_request['utc'];
}
else
{
    $cur_timezone_formated = $arr_request['utc'];
}

$cur_timezone_formated = str_replace('.5', ':30', $cur_timezone_formated);
$cur_timezone_formated = str_replace('.75', ':45', $cur_timezone_formated);


if(isset($arr_request['sent']))
{
	// set the server timezone to UTC
	date_default_timezone_set('UTC');

	if($arr_request['sent'] == "ts2t")
	{
	    $date = gmdate('d;m;Y;H;i;s', $arr_request['timestamp'] + ($arr_request['utc'] * 3600));

	    $arr_date = explode(';', $date);

        $arr_request['day'] = (strlen($arr_date[0]) == 1) ? '0' . $arr_date[0] : $arr_date[0];
        $arr_request['month'] = (strlen($arr_date[1]) == 1) ? '0' . $arr_date[1] : $arr_date[1];
        $arr_request['year'] = $arr_date[2];
        $arr_request['hour'] = (strlen($arr_date[3]) == 1) ? '0' . $arr_date[3] : $arr_date[3];
        $arr_request['minute'] = (strlen($arr_date[4]) == 1) ? '0' . $arr_date[4] : $arr_date[4];
        $arr_request['second'] = (strlen($arr_date[5]) == 1) ? '0' . $arr_date[5] : $arr_date[5];

        $ts2t_notice = sprintf(TS2T_NOTICE,  $arr_request['timestamp'],  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $cur_timezone_formated);
        $t2ts_notice = sprintf(T2TS_NOTICE,  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $arr_request['timestamp'], $cur_timezone_formated);
	}
	elseif($arr_request['sent'] == "t2ts")
	{
	    if($arr_request['year'] == 70 && $arr_request['hour'] < 1)
	    {
	        $arr_request['year'] = 70;
	        $arr_request['hour'] = 1;
	    }

	    if(!isset($arr_request['day']) || $check->input($arr_request['day'], 'numeric') == false)
        {
            $arr_request['day'] = 1;
        }

	    if(!isset($arr_request['month']) || $check->input($arr_request['month'], 'numeric') == false)
        {
            $arr_request['month'] = 1;
        }

	    if(!isset($arr_request['year']) || $check->input($arr_request['year'], 'numeric') == false)
	    {
	    	  $arr_request['year'] = 1970;
	    }

	    if($arr_request['year'] < 1969)
        {
          $arr_request['year'] = 1970;
        }
        elseif($arr_request['year'] > 2039)
        {
          $arr_request['year'] = 2037;
        }

	    if(checkdate($arr_request['month'], $arr_request['day'], $arr_request['year']) == false)
	    {
	        $arr_request['day'] = 01;
	        $arr_request['month'] = 01;
	        $arr_request['year'] = 1970;
	    }

	    if(!isset($arr_request['hour']) || $check->input($arr_request['hour'], 'numeric') == false)
        {
            $arr_request['hour'] = 0;
        }

	    if($arr_request['hour'] < 0 || $arr_request['hour'] > 24)
	    {
	        $arr_request['hour'] = 0;
	    }

	    if(!isset($arr_request['minute']) || $check->input($arr_request['minute'], 'numeric') == false)
        {
            $arr_request['minute'] = 0;
        }

	    if($arr_request['minute'] < 0 || $arr_request['minute'] > 59)
	    {
	        $arr_request['minute'] = 0;
	    }

	    if(!isset($arr_request['second']) || $check->input($arr_request['second'], 'numeric') == false)
        {
            $arr_request['second'] = 0;
        }

	    if($arr_request['second'] < 0 || $arr_request['second'] > 59)
	    {
	        $arr_request['second'] = 0;
	    }

	    $arr_date = array($arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second']);
	    $arr_request['timestamp'] = mktime(intval($arr_request['hour']), intval($arr_request['minute']), intval($arr_request['second']), intval($arr_request['month']), intval($arr_request['day']), intval($arr_request['year']));

	    $arr_request['timestamp'] = $arr_request['timestamp'] - ($arr_request['utc'] * 3600);

	    $ts2t_notice = sprintf(TS2T_NOTICE,  $arr_request['timestamp'],  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $cur_timezone_formated);
	    $t2ts_notice = sprintf(T2TS_NOTICE,  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $arr_request['timestamp'], $cur_timezone_formated);
	}
}
else
{
	$arr_request['timestamp'] = time();
	$arr_request['day'] = date('d');
    $arr_request['month'] = date('m');
    $arr_request['year'] = date('Y');
    $arr_request['hour'] = date('H');
    $arr_request['minute'] = date('i');
    $arr_request['second'] = date('s');

    $ts2t_notice = sprintf(TS2T_NOTICE,  $arr_request['timestamp'],  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $cur_timezone_formated);
    $t2ts_notice = sprintf(T2TS_NOTICE,  $arr_request['day'], $arr_request['month'], $arr_request['year'], $arr_request['hour'], $arr_request['minute'], $arr_request['second'], $arr_request['timestamp'], $cur_timezone_formated);
}


//
// utc pulldown values
foreach($arr_timezones as $key => $value)
{
    $arr_utc_pull_down_val[] = array('id'    => $value,
                                     'text'  => $key,
                                     'value' => $value);
}

//
// make forms
$form_ts2t = $html->form('ts2t', 'https://tools.confirado.de/timestampconverter/index.php') .
             '<label for="timestamp">' . FORM_TIMESTAMP_TEXT . '</label>' .
             $html->input_field('timestamp', $arr_request['timestamp'], 'type="number" id="timestamp" required') . '<br />' .
             '<label for="utc">' . FORM_UTC_TEXT . '</label>' .
             $html->pull_down_menu('utc', $arr_utc_pull_down_val, $arr_request['utc'], 'id="utc"') . '<br />' .
             $html->hidden_field('sent', 'ts2t') .
             $html->hidden_field('addon', 'aritso-tools') .
             $html->hidden_field('action', 'timestampconverter') .
             $html->form_submit(TS2T_SEND_BUTTON_TEXT, '', true);

$form_t2ts = $html->form('t2ts', 'https://tools.confirado.de/timestampconverter/index.php') .
             '<label for="day">' . FORM_DATE_TEXT . '</label>' .
             $html->input_field('day', $arr_request['day'], 'type="number" id="day" style="float:left; margin-right:1px;" required') .
             $html->input_field('month', $arr_request['month'], 'type="number" id="month" style="float:left; margin-right:1px;" required') .
             $html->input_field('year', $arr_request['year'], 'type="number" id="year" style="float:left; margin-right:1px;" required') .
             '<br style="clear:left;" /><label for="hour">' . FORM_TIME_TEXT . '</label>' .
             $html->input_field('hour', $arr_request['hour'], 'type="number" id="hour" style="float:left; margin-right:1px;" required') .
             $html->input_field('minute', $arr_request['minute'], 'type="number" id="minute" style="float:left; margin-right:1px;" required') .
             $html->input_field('second', $arr_request['second'], 'type="number" id="second" style="float:left; margin-right:1px;" required') .
             '<br style="clear:left;" /><label for="utc">' . FORM_UTC_TEXT . '</label>' .
             $html->pull_down_menu('utc', $arr_utc_pull_down_val, $arr_request['utc'], 'id="utc"') . '<br />' .
             $html->hidden_field('sent', 't2ts') .
             $html->hidden_field('addon', 'aritso-tools') .
             $html->hidden_field('action', 'timestampconverter') .
             $html->form_submit(T2TS_SEND_BUTTON_TEXT, '', true);
?>

<!doctype html>
<html lang="de">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="robots" content="noindex,nofollow">

	<link rel="stylesheet" href="../_css_/screen_layout.css">
	
    <title>Timestampconverter</title>
  </head>
  <body>
  
	<h3 style="margin-top:34px;">Einen Unix-Timestamp in ein Datum umrechnen</h3>
	<div>
		<div id="ts2t_notice"><?php echo $ts2t_notice; ?></div>
		<div id="ts2t_form"><?php echo $form_ts2t; ?></div>
	</div>

	<hr />

	<h3 style="margin-top:34px;">Ein Datum in einen Unix-Timestamp umrechnen</h3>
	<div>
		<div id="t2ts_notice"><?php echo $t2ts_notice; ?></div>
		<div id="t2ts_form"><?php echo $form_t2ts; ?></div>
	</div>
  
  </body>
</html>